getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(tensorA)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)

load("s1-ini-setting-p-1.RData")

## Model: f(x) = B*U1*U2*x; B: 3*3*2, U1/2: 3*3, x:3*2
dim.b = c(3,3,3); dim.u1 = c(2,3); dim.u2 = c(4,3); dim.x = c(2,3)
dim.f = c(2,4,2); dim.s = dim.f
dim.h = prod(dim.s); dim.mode = length(dim.s)
d = 3; lower.x = rep(0,d); upper.x = rep(1,d)
k = ceiling(dim.h/6)

B <- e1.ini.set.p$B
U_mat <- e1.ini.set.p$U_mat
V <- e1.ini.set.p$V

true.model <- function(x){
  X1 = sin(5*x); X2 = cos(x)
  X = matrix(cbind(X1,X2),dim.x)
  return(array(ttm(V, X, m = 3)@data,dim.f))
}

true.h <- function(x,ind) {
  sele.f <- true.model(x)[ind]
  return(sum(sele.f))
}

ora.h <- function(x,k) {
  sele.f <- sort(true.model(x), decreasing = TRUE)[1:k]
  return(sum(sele.f))
}

ora.to.re = directL(function(x0) -ora.h(x0,k),lower.x,upper.x,control=list(xtol_rel=1e-8, maxeval=1000))
ora.x.star = ora.to.re$par
ora.x.star = t(as.matrix(ora.x.star))

ora.ind.star = arrayInd(order(true.model(ora.x.star), decreasing = TRUE)[1:k],dim.f)
ora.f.star = true.model(ora.x.star)
ora.h.star = ora.h(ora.x.star,k)


## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  x = norm1(x1,x2)
  dis = Map(function(x0,th) x0/th,x,theta)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

noise <- function(x1,x2){
  no.ind = which(apply(x1, 1, function(row_a) apply(x2, 1, function(row_b) all(row_a == row_b))), arr.ind = TRUE)
  no.0 = matrix(0,nrow(x2),nrow(x1))
  no.0[no.ind] = 1
  return(t(no.0))
}

pos <- function(ind) array(1:dim.h,dim.f)[ind]

e.ind <- function(ind){
  e0 = pos(ind); ord = cbind(1:k,e0)
  e.re = matrix(0,k,dim.h)
  e.re[ord] = 1
  return(e.re)
}


################################################################################
#### GP ########################################################################
################################################################################

################################################################################
## Our proposed method: NS-TOGP
vec.lab = list()
vec.lab[[1]] = dim.h*(dim.h+1)/2
vec.lab[[2]] = d
vec.lab[[3]] = vec.lab[[4]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.mt = length(group.lab)

lower.th = c(unlist(Map(rep, c(1e-3,1e-3,1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(1,10,10,1e-2), unlist(vec.lab))))

sig.mt <- function(t,ome){
  O = matrix(0,t,t)
  O[lower.tri(O, diag = T)] <- ome
  return(O)
}

likeli.mt <- function(x1,x2,y,ind,n,t0,the){
  the0 = split(the, group.lab)
  
  k.ini = the0[[3]]*ker.sele(x1,x2,the0[[2]],mat0)+the0[[4]]*noise(x1,x2)
  omega = sig.mt(t0,the0[[1]])%*%t(sig.mt(t0,the0[[1]]))
  k.y = kronecker(k.ini,omega)
  
  e.ini = as.matrix(bdiag(lapply(ind,e.ind)))
  par.k.y = e.ini%*%k.y%*%t(e.ini)
  sol.par.k.y = solve(e.ini%*%k.y%*%t(e.ini))
  
  log.likeli = determinant(par.k.y,logarithm=TRUE)$modulus+
    t(c(y))%*%sol.par.k.y%*%c(y)
  return(list(like=log.likeli, the0=the0))
}
# likeli.mt(x,x,y,k.ind,n,dim.h,c(runif(dim.hyper.mt)))


mtgp.hat <- function(x.new,ind.new,x,y,ind,n,n.test,t0,hy){
  x.new = matrix(x.new,n.test,d)
  e.new = as.matrix(bdiag(lapply(ind.new,e.ind)))
  e.ini = as.matrix(bdiag(lapply(ind,e.ind)))
  
  omega = sig.mt(t0,hy[[1]])%*%t(sig.mt(t0,hy[[1]]))
  
  k.mt.s0 = hy[[3]]*ker.sele(x,x,hy[[2]],mat0)+hy[[4]]*noise(x,x)
  k.mt.s = kronecker(k.mt.s0,omega)
  
  k.mt.10 = hy[[3]]*ker.sele(x.new,x,hy[[2]],mat0)+hy[[4]]*noise(x.new,x)
  k.mt.1 = kronecker(k.mt.10,omega)%*%t(e.ini)
  
  k.mt.00 = hy[[3]]*ker.sele(x.new,x.new,hy[[2]],mat0)+hy[[4]]*noise(x.new,x.new)
  k.mt.0 = kronecker(k.mt.00,omega)
  
  k.oth = k.mt.1%*%solve(e.ini%*%k.mt.s%*%t(e.ini))
  
  f.hat = k.oth%*%c(y)
  var.hat = hy[[3]]*(k.mt.0-k.oth%*%t(k.mt.1))
  
  par.k.mt.1 = e.new%*%k.mt.1
  par.k.mt.0 = e.new%*%k.mt.0%*%t(e.new)
  par.k.oth = e.new%*%k.oth
  
  par.f.hat = par.k.oth%*%c(y)
  par.var.hat = hy[[3]]*(par.k.mt.0-par.k.oth%*%t(par.k.mt.1))
  
  result = list(mean = f.hat, cov = var.hat, par.mean = par.f.hat, par.cov = par.var.hat)
  return(result)
}
# mtgp.hat(ora.x.star,ora.ind.star,x,y,k.ind,n,1,dim.h,split(the, group.lab))


EIJ <- function(i,j){
  E0 = matrix(0,dim.h,dim.h); E0[i,j] = 1
  return(E0)
}

der.l <- function(x1,x2,y,ind,n,the){
  the0 = split(the, group.lab)
  ome = the0[[1]]; th = the0[[2]]; sig2 = the0[[3]]; tau2 = the0[[4]]
  
  J <- function(i){
    E0 = matrix(0,dim.h,dim.h); E0[i,i] = exp(sig.mt(dim.h,the0[[1]])[i,i])
    return(E0)
  }
  
  k.ini0 = ker.sele(x1,x2,the0[[2]],mat0)
  k.ini = the0[[3]]*k.ini0+the0[[4]]*noise(x1,x2)
  omega = sig.mt(dim.h,the0[[1]])%*%t(sig.mt(dim.h,the0[[1]]))
  sol.o = solve(omega)
  
  k.y = kronecker(k.ini,omega)
  
  e.ini = as.matrix(bdiag(lapply(ind,e.ind)))
  par.k.y = e.ini%*%k.y%*%t(e.ini)
  sol.par.k.y = solve(e.ini%*%k.y%*%t(e.ini))
  
  al.k = sol.par.k.y%*%c(y)
  al.k1 = e.ini%*%kronecker(k.ini0,omega)%*%t(e.ini)
  al.k2 = e.ini%*%kronecker(diag(n),omega)%*%t(e.ini)
  der.l.sig = tr(sol.par.k.y%*%al.k1)-t(al.k)%*%al.k1%*%al.k
  der.l.tau2 = tr(sol.par.k.y%*%al.k2)-t(al.k)%*%al.k2%*%al.k
  
  der.th = array(jacobian(function(theta) ker.sele(x1,x2,theta,mat0), th),dim=c(n,n,d))
  der.l.th.i <- function(der) sig2*(tr(t(e.ini)%*%sol.par.k.y%*%e.ini%*%kronecker(der,omega))-
                                      t(al.k)%*%e.ini%*%kronecker(der,omega)%*%t(e.ini)%*%al.k)
  der.l.th = apply(der.th,3,der.l.th.i)
  
  
  der.l.phi.ij <- function(i,j) as.numeric(tr(sol.par.k.y%*%e.ini%*%kronecker(k.ini,(EIJ(i,j)%*%t(omega)+omega%*%EIJ(j,i)))%*%t(e.ini))-
                                             t(al.k)%*%e.ini%*%kronecker(k.ini,(EIJ(i,j)%*%t(omega)+omega%*%EIJ(j,i)))%*%t(e.ini)%*%al.k)
  der.l.phi.1 = sapply(c(1:dim.h), function(i) {
    sapply(c(1:i), function(j) der.l.phi.ij(i, j))
  })
  
  der.l.phi.ii <- function(i) tr(sol.par.k.y%*%e.ini%*%kronecker(k.ini,(J(i)%*%t(omega)+omega%*%J(i)))%*%t(e.ini))-
    t(al.k)%*%e.ini%*%kronecker(k.ini,(J(i)%*%t(omega)+omega%*%J(i)))%*%t(e.ini)%*%al.k
  der.l.phi.dig = apply(as.matrix(c(1:dim.h)),1, der.l.phi.ii)
  
  der.l.phi = matrix(0, dim.h, dim.h)
  for (i in 1:dim.h) {
    der.l.phi[i, 1:i] <- der.l.phi.1[[i]]
  }
  diag(der.l.phi) = der.l.phi.dig
  
  result = list(der.l.phi=der.l.phi[lower.tri(der.l.phi, diag = T)], der.l.th=der.l.th, der.l.sig=der.l.sig, der.l.tau2=der.l.tau2)
  return(result)
}


################################################################################
## Our proposed method: NS-TOGP-UCB
n = 5*d; m  = 10*d; lambda = 0.1; J.for=10

like.re.mt = hyper.mt = lapply(1:J.for, function(x) list())
x0.mt = y0.mt = ind0.mt = list(); fhat = lapply(1:J.for, function(x) list())
mtgp.bo = h.mt = list()
mse.x.mt = mae.y.mt = list(); tab.ind.mt = list()
regret.mt = ins.regret.mt = cum.regret.mt = list()


for(j.for.mt in 1:J.for){
  x = e1.ini.set.p$x 
  k.ind = e1.ini.set.p$k.ind
  y = e1.ini.set.p$y.for[[j.for.mt]]
  
  
  ## Setting
  ######################################## BO ####################################
  hyper.mt.old = directL(function(the) likeli.mt(x,x,y,k.ind,n,dim.h,the)$like,lower.th,upper.th,control=list(maxeval=1000))$par
  opts <- list("algorithm"="NLOPT_LD_LBFGS", "xtol_rel"=1.0e-5)
  hyper.mt.new <- nloptr(x0=hyper.mt.old,
                         eval_f = function(the) likeli.mt(x,x,y,k.ind,n,dim.h,the)$like,
                         eval_grad_f=function(the) unlist(der.l(x,x,y,k.ind,n,the)),
                         opts=opts,lb = lower.th, ub = upper.th)$solution
  like.re.mt[[j.for.mt]][[1]] = likeli.mt(x,x,y,k.ind,n,dim.h,hyper.mt.new)
  hyper.mt[[j.for.mt]][[1]] = like.re.mt[[j.for.mt]][[1]]$the0
  
  x0.mt[[j.for.mt]] = x; y0.mt[[j.for.mt]] = y; n.mt = n
  ind0.mt[[j.for.mt]] = k.ind
  
  y.new.mt = y[,which.max(apply(y,2,sum))]
  x.new.mt = t(as.matrix(x[which.max(apply(y,2,sum)),]))
  ind.new.mt = list(k.ind[[which.max(apply(y,2,sum))]])
  
  hyper.mt.ucb = unlist(hyper.mt[[j.for.mt]][[1]]); delta.mt = 0.05
  fhat[[j.for.mt]][[1]] = mtgp.hat(x.new.mt,ind.new.mt,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],n.mt,1,dim.h,hyper.mt[[j.for.mt]][[1]])
  
  for(i.mt in 1:m){
    x.new.mt = t(t(randomLHS(1,d))*(upper.x-lower.x) + lower.x)
    ind.new.mt = list(arrayInd(sample(dim.h,k),dim.f))
    
    fhat[[j.for.mt]][[i.mt+1]] = mtgp.hat(x.new.mt,ind.new.mt,x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],n.mt,n.test=1,dim.h,hyper.mt[[j.for.mt]][[i.mt]])
    y.new.mt = true.model(x.new.mt)[ind.new.mt[[1]]]+rnorm(k,mean=0,sd=hyper.mt[[j.for.mt]][[i.mt]][[2]][2])
    
    x0.mt[[j.for.mt]] = rbind(x0.mt[[j.for.mt]], x.new.mt)
    y0.mt[[j.for.mt]] = cbind(y0.mt[[j.for.mt]], y.new.mt)
    ind0.mt[[j.for.mt]] = append(ind0.mt[[j.for.mt]], ind.new.mt)
    
    n.mt = n+i.mt
    
    if(i.mt %% 50 == 0){
      hyper.mt.ucb = optim(par = unlist(hyper.mt[[j.for.mt]][[i.mt]]), fn = function(the) likeli.mt(
        x0.mt[[j.for.mt]],x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],n.mt,dim.h,the)$like, 
        gr = function(the) unlist(der.l(x,x,y,k.ind,n,the)), method = "L-BFGS-B")$par
    }else{
      hyper.mt.ucb = hyper.mt.ucb
    }
    
    like.re.mt[[j.for.mt]][[i.mt+1]] = likeli.mt(x0.mt[[j.for.mt]],x0.mt[[j.for.mt]],y0.mt[[j.for.mt]],ind0.mt[[j.for.mt]],n.mt,dim.h,hyper.mt.ucb)
    hyper.mt[[j.for.mt]][[i.mt+1]] = like.re.mt[[j.for.mt]][[i.mt+1]]$the0
    print(i.mt)
  }
  
  mtgp.bo[[j.for.mt]] = Map(function(a,b) true.model(a)[b],split(x0.mt[[j.for.mt]],row(x0.mt[[j.for.mt]])),ind0.mt[[j.for.mt]])
  h.mt[[j.for.mt]] = Map(function(a,b) true.h(a,b),split(x0.mt[[j.for.mt]],row(x0.mt[[j.for.mt]])),ind0.mt[[j.for.mt]])
  
  mse.x.mt[[j.for.mt]] = apply(x0.mt[[j.for.mt]],1,function(x) mean((x-ora.x.star)^2))
  mae.y.mt[[j.for.mt]] = unlist(lapply(fhat[[j.for.mt]],function(a) mean(abs((a$par.mean-c(ora.f.star[ora.ind.star]))/c(ora.f.star[ora.ind.star])))))
  tab.ind.mt[[j.for.mt]] = unlist(lapply(ind0.mt[[j.for.mt]],function(a) sum(apply(a, 1, function(row) any(duplicated(rbind(row, ora.ind.star)))))))#unlist(lapply(ind0.mt[[j.for.mt]],function(a) sum(apply(a == ora.ind.star, 1, all))))
  
  regret.mt[[j.for.mt]] = ora.h.star-unlist(h.mt[[j.for.mt]])
  ins.regret.mt[[j.for.mt]] = ora.h.star-cummax(unlist(h.mt[[j.for.mt]]))
  cum.regret.mt[[j.for.mt]] = cumsum(ins.regret.mt[[j.for.mt]])
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(ora.h.star,(n.mt-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(unlist(h.mt[[j.for.mt]]))[n],ora.h.star))
  lines(cummax(unlist(h.mt[[j.for.mt]]))[n:n.mt],type="b",lwd=3,lty=2,pch=2,col=2)
  
  plot(log(ins.regret.mt[[j.for.mt]]+1e-10)[n:n.mt],type="b",lwd=3,lty=1,pch=1,col=1)
  
  print(j.for.mt)
}


pmv.rs.list = list(like.re.mt=like.re.mt, hyper.mt=hyper.mt, 
                    ind0.mt=ind0.mt, tab.ind.mt=tab.ind.mt,
                    x0.mt=x0.mt, y0.mt=y0.mt, mtgp.bo=mtgp.bo, h.mt=h.mt, 
                    mse.x.mt=mse.x.mt, mse.y.mt=mse.y.mt, regret.mt=regret.mt,
                    ins.regret.mt=ins.regret.mt, cum.regret.mt=cum.regret.mt)
save(pmv.rs.list, file="s1.pmv.rs.RData")

